﻿Imports System
Imports System.Xml
Partial Class ASTGDWeather
    Inherits System.Web.UI.UserControl
    Dim location As String = "New+York"
    Dim hideonerrorval As Boolean = False
    Dim viewcelcius As Boolean = False
    Dim userweather As Boolean = False

    Public Property showcelcius() As Boolean
        Get
            Return viewcelcius
        End Get
        Set(ByVal value As Boolean)
            viewcelcius = value
        End Set
    End Property
    Public Property setlocation() As String
        Get
            Return location
        End Get
        Set(ByVal value As String)
            location = value
        End Set
    End Property
    Public Property hideonerror() As Boolean
        Get
            Return hideonerrorval
        End Get
        Set(ByVal value As Boolean)
            hideonerrorval = value
        End Set
    End Property
    Public Property showuserweather() As Boolean
        Get
            Return userweather
        End Get
        Set(ByVal value As Boolean)
            userweather = value
        End Set
    End Property

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Not Page.IsPostBack Then
            Select Case userweather
                Case False
                Case True
                    Dim userip As String
                    userip = Request.ServerVariables("REMOTE_ADDR")
                    Dim doc1 As New XmlDocument
                    doc1.Load("http://ipinfodb.com/ip_query.php?ip=" & userip & "&timezone=false")
                    For Each ifnote As XmlNode In doc1.DocumentElement.ChildNodes
                        If ifnote.Name = "City" Then
                            location = ifnote.InnerText
                        End If
                    Next
            End Select

            Dim doc As New XmlDocument
            errordiv.Visible = False
            maindiv.Visible = True
            'Set the location at the bottom
            bottom.InnerText = location
            bottom1.InnerText = location
            'Replace white spaces with + sign
            location = location.Replace(" ", "+")

            'Load the xml document
            doc.Load("http://www.google.com/ig/api?weather=" & location)

            'Get the Weather Root Node
            Dim fnode As XmlElement = doc.DocumentElement.FirstChild

            'Check failure
            If fnode.FirstChild.Name = "problem_cause" Then
                'Data retrieval failed, call the local xml file
                If System.IO.File.Exists(Server.MapPath("Controls\") & location & ".xml") Then
                    doc.Load(Server.MapPath("Controls\") & location & ".xml")
                Else
                    'Check hideonerror value
                    If hideonerrorval = False Then
                        'Do not hide
                        errordetails.InnerText = "There is an error occured while retriving data. Try again later."
                        errordiv.Visible = True
                        maindiv.Visible = False
                        Exit Sub
                    Else
                        'Hide the whole control
                        maindiv.Visible = False
                        errordiv.Visible = False
                    End If
                End If
            End If

            'There was no error reading the content, now save it for future use
            doc.Save(Server.MapPath("Controls\") & location & ".xml")

            'Multiple forcast condition counter
            Dim forcastnum As Integer = 0

            'Get all nodes in Weather Root Node
            For Each cnode As XmlNode In fnode.ChildNodes
                Select Case cnode.Name
                    Case "forecast_information"
                        'This node contains the location information

                    Case "current_conditions"
                        For Each ccnode As XmlNode In cnode.ChildNodes
                            Select Case ccnode.Name
                                Case "condition"
                                    ConditionTitle.InnerText = (ccnode.Attributes("data").Value)
                                Case "temp_f"
                                    CurrentTemp.InnerHtml = ccnode.Attributes("data").Value & "&deg; F"
                                Case "temp_c"
                                    If viewcelcius = True Then
                                        CurrentTemp.InnerHtml = ccnode.Attributes("data").Value & "&deg; C"
                                    End If
                                Case "humidity"
                                    Humidity.InnerText = ccnode.Attributes("data").Value.Replace("Humidity: ", "")
                                Case "wind_condition"
                                    Wind.InnerText = ccnode.Attributes("data").Value.Replace("Wind: ", "")
                                Case "icon"
                                    CurrentIcon.Src = "http://www.google.com" & ccnode.Attributes("data").Value
                            End Select
                        Next
                    Case "forecast_conditions"
                        forcastnum = forcastnum + 1
                        Select Case forcastnum
                            Case 1
                                For Each ccnode As XmlNode In cnode.ChildNodes
                                    Select Case ccnode.Name
                                        Case "day_of_week"
                                            daytitle1.InnerText = (ccnode.Attributes("data").Value)
                                        Case "low"
                                            highlow1.InnerText = ccnode.Attributes("data").Value
                                        Case "high"
                                            highlow1.InnerText = highlow1.InnerText & "/" & ccnode.Attributes("data").Value
                                        Case "icon"
                                            dayicon1.Src = "http://www.google.com" & ccnode.Attributes("data").Value
                                        Case "condition"
                                            condition1.InnerText = ccnode.Attributes("data").Value
                                    End Select
                                Next
                            Case 2
                                For Each ccnode As XmlNode In cnode.ChildNodes
                                    Select Case ccnode.Name
                                        Case "day_of_week"
                                            daytitle2.InnerText = (ccnode.Attributes("data").Value)
                                        Case "low"
                                            highlow2.InnerText = ccnode.Attributes("data").Value
                                        Case "high"
                                            highlow2.InnerText = highlow2.InnerText & "/" & ccnode.Attributes("data").Value
                                        Case "icon"
                                            dayicon2.Src = "http://www.google.com" & ccnode.Attributes("data").Value
                                        Case "condition"
                                            condition2.InnerText = ccnode.Attributes("data").Value
                                    End Select
                                Next
                            Case 3
                                For Each ccnode As XmlNode In cnode.ChildNodes
                                    Select Case ccnode.Name
                                        Case "day_of_week"
                                            daytitle3.InnerText = (ccnode.Attributes("data").Value)
                                        Case "low"
                                            highlow3.InnerText = ccnode.Attributes("data").Value
                                        Case "high"
                                            highlow3.InnerText = highlow3.InnerText & "/" & ccnode.Attributes("data").Value
                                        Case "icon"
                                            dayicon3.Src = "http://www.google.com" & ccnode.Attributes("data").Value
                                        Case "condition"
                                            condition3.InnerText = ccnode.Attributes("data").Value
                                    End Select
                                Next
                        End Select
                End Select
            Next
        End If
    End Sub
    Private Sub writedata(ByVal divofinterest As Object, ByVal val As Integer)

    End Sub
End Class
